/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering.lighting;

import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;
import technology.rocketjump.undermount.assets.entities.furniture.model.DoorState;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.layout.TileLayoutAtlas;
import technology.rocketjump.undermount.mapping.tile.wall.Edge;
import technology.rocketjump.undermount.mapping.tile.wall.WallEdgeAtlas;
import technology.rocketjump.undermount.mapping.tile.wall.WallEdgeDefinition;
import technology.rocketjump.undermount.rendering.lighting.ClockwisePointComparator;
import technology.rocketjump.undermount.rendering.lighting.NearestEdgeComparator;
import technology.rocketjump.undermount.rendering.lighting.PointLight;

public class LightProcessor {
    public static final float EPSILON = 1.0E-4f;
    private final TileLayoutAtlas tileLayoutAtlas;
    private final WallEdgeAtlas wallEdgeAtlas;

    @Inject
    public LightProcessor(TileLayoutAtlas tileLayoutAtlas, WallEdgeAtlas wallEdgeAtlas) {
        this.tileLayoutAtlas = tileLayoutAtlas;
        this.wallEdgeAtlas = wallEdgeAtlas;
    }

    public void updateLightGeometry(PointLight light, TiledMap worldMap) {
        Array<Edge> lightGeometry = light.getLightPolygonEdges();
        lightGeometry.clear();
        TreeMap<Vector2, List<Edge>> sortedPointsToWallEdges = new TreeMap<Vector2, List<Edge>>(new ClockwisePointComparator());
        HashSet<Edge> allEdges = new HashSet<Edge>();
        this.buildSortedPointToEdgeMap(light, worldMap, sortedPointsToWallEdges, allEdges);
        HashSet<Vector2> visitedPoints = new HashSet<Vector2>(sortedPointsToWallEdges.size());
        PriorityQueue<Edge> nearestEdgesToConsider = new PriorityQueue<Edge>(new NearestEdgeComparator());
        PriorityQueue<Edge> nearestStartingEdges = this.getEdgesAboveOriginThatCrossXAxis(allEdges);
        Edge currentEdge = nearestStartingEdges.peek();
        if (currentEdge == null) {
            return;
        }
        nearestEdgesToConsider.addAll(nearestStartingEdges);
        Vector2 previousVisiblePoint = this.calculateInitialPreviouslyVisiblePoint(light, sortedPointsToWallEdges, currentEdge);
        if (previousVisiblePoint == null) {
            return;
        }
        for (Map.Entry<Vector2, List<Edge>> sortedMapEntry : sortedPointsToWallEdges.entrySet()) {
            Vector2 currentPoint = sortedMapEntry.getKey();
            List<Edge> edgesForPoint = sortedMapEntry.getValue();
            for (Edge edgeForPoint : edgesForPoint) {
                if (edgeForPoint.getPointA().epsilonEquals(currentPoint, 1.0E-4f)) {
                    nearestEdgesToConsider.add(edgeForPoint);
                    continue;
                }
                nearestEdgesToConsider.remove(edgeForPoint);
            }
            if (nearestEdgesToConsider.peek() != null && !nearestEdgesToConsider.peek().equals(currentEdge)) {
                Vector2 intersection;
                Edge lastEdge = currentEdge;
                currentEdge = nearestEdgesToConsider.peek();
                if (currentEdge.averageEndpointDistanceSquared() < lastEdge.averageEndpointDistanceSquared()) {
                    intersection = this.intersection(currentPoint, lastEdge, PointLight.LIGHT_RADIUS);
                    lightGeometry.add(new Edge(previousVisiblePoint, intersection));
                    previousVisiblePoint = currentPoint;
                } else {
                    Vector2 intersectionOnNewEdge;
                    intersection = this.intersection(previousVisiblePoint, lastEdge, PointLight.LIGHT_RADIUS);
                    lightGeometry.add(new Edge(intersection, currentPoint));
                    previousVisiblePoint = intersectionOnNewEdge = this.intersection(currentPoint, currentEdge, PointLight.LIGHT_RADIUS);
                }
            }
            visitedPoints.add(currentPoint);
        }
        light.updateMesh();
    }

    private void buildSortedPointToEdgeMap(PointLight light, TiledMap worldMap, TreeMap<Vector2, List<Edge>> sortedPointsToWallEdges, Set<Edge> allEdges) {
        this.addBoundingBoxEdges(light, sortedPointsToWallEdges, worldMap, allEdges);
        Vector2 lightPosition = light.getWorldPosition();
        int lightTileX = (int)Math.floor(lightPosition.x);
        int lightTileY = (int)Math.floor(lightPosition.y);
        int yCursor = lightTileY - Math.round(PointLight.LIGHT_RADIUS);
        while ((float)yCursor <= (float)lightTileY + PointLight.LIGHT_RADIUS) {
            int xCursor = lightTileX - Math.round(PointLight.LIGHT_RADIUS);
            while ((float)xCursor <= (float)lightTileX + PointLight.LIGHT_RADIUS) {
                MapTile mapTile = worldMap.getTile(xCursor, yCursor);
                if (mapTile != null && mapTile.hasWall()) {
                    int simplifiedLayoutId = this.tileLayoutAtlas.simplifyLayoutId(mapTile.getWall().getTrueLayout().getId());
                    WallEdgeDefinition edgeDefinition = this.wallEdgeAtlas.getForLayoutId(simplifiedLayoutId);
                    this.addEdgeDefinitionToEdgeMap(light, sortedPointsToWallEdges, allEdges, lightPosition, yCursor, xCursor, edgeDefinition);
                } else if (mapTile != null && mapTile.hasDoorway()) {
                    for (Entity wallCapEntity : mapTile.getDoorway().getWallCapEntities()) {
                        WallEdgeDefinition edgeDefinition = this.wallEdgeAtlas.getForWallCap(wallCapEntity, mapTile.getDoorway());
                        this.addEdgeDefinitionToEdgeMap(light, sortedPointsToWallEdges, allEdges, lightPosition, yCursor, xCursor, edgeDefinition);
                    }
                    if (mapTile.getDoorway().getDoorState().equals((Object)DoorState.CLOSED)) {
                        WallEdgeDefinition edgeDefinition = this.wallEdgeAtlas.getForClosedDoor(mapTile.getDoorway());
                        this.addEdgeDefinitionToEdgeMap(light, sortedPointsToWallEdges, allEdges, lightPosition, yCursor, xCursor, edgeDefinition);
                    }
                }
                ++xCursor;
            }
            ++yCursor;
        }
    }

    private void addEdgeDefinitionToEdgeMap(PointLight light, TreeMap<Vector2, List<Edge>> sortedPointsToWallEdges, Set<Edge> allEdges, Vector2 lightPosition, int yCursor, int xCursor, WallEdgeDefinition edgeDefinition) {
        Array<Edge> edges = edgeDefinition.getEdgesForVisibilityPolygon(new Vector2(lightPosition.x - (float)xCursor, lightPosition.y - (float)yCursor));
        for (Edge edge : edges) {
            Edge edgeRelativeToLight = new Edge(new Vector2(xCursor, yCursor).add(edge.getPointA()).sub(lightPosition), new Vector2(xCursor, yCursor).add(edge.getPointB()).sub(lightPosition));
            if (!this.withinRadiusBounds(edgeRelativeToLight, PointLight.LIGHT_RADIUS)) continue;
            this.addEdgeToMap(edgeRelativeToLight, sortedPointsToWallEdges, allEdges);
        }
    }

    private boolean withinRadiusBounds(Edge edge, float radius) {
        return Math.abs(edge.getPointA().x) < radius && Math.abs(edge.getPointA().y) < radius && Math.abs(edge.getPointB().x) < radius && Math.abs(edge.getPointB().y) < radius;
    }

    private PriorityQueue<Edge> getEdgesAboveOriginThatCrossXAxis(Set<Edge> allEdges) {
        PriorityQueue<Edge> nearestStartingEdges = new PriorityQueue<Edge>(new NearestEdgeComparator());
        for (Edge edge : allEdges) {
            if (!(edge.getPointA().y > 0.0f && edge.getPointB().y > 0.0f && edge.getPointA().x < 0.0f && edge.getPointB().x >= 0.0f) && (!(edge.getPointA().y > 0.0f) || !(edge.getPointB().y > 0.0f) || !(edge.getPointA().x > 0.0f) || !(edge.getPointB().x <= 0.0f))) continue;
            nearestStartingEdges.add(edge);
        }
        return nearestStartingEdges;
    }

    private Vector2 calculateInitialPreviouslyVisiblePoint(PointLight light, TreeMap<Vector2, List<Edge>> sortedPointsToWallEdges, Edge initialEdge) {
        Vector2 previousVisiblePoint = null;
        NavigableSet<Vector2> sortedPointsInReverse = sortedPointsToWallEdges.descendingKeySet();
        for (Vector2 pointToCheck : sortedPointsInReverse) {
            if (pointToCheck.equals(initialEdge.getPointA())) {
                previousVisiblePoint = initialEdge.getPointA();
                break;
            }
            if (!(pointToCheck.y <= initialEdge.getPointA().y)) continue;
            previousVisiblePoint = this.intersection(pointToCheck, initialEdge, PointLight.LIGHT_RADIUS);
            break;
        }
        return previousVisiblePoint;
    }

    private Vector2 intersection(Vector2 direction, Edge edge, float lightRadius) {
        float extendedlightRadius = lightRadius * 1.5f;
        float smallestDirectionComponent = Math.min(Math.abs(direction.x), Math.abs(direction.y));
        smallestDirectionComponent = Math.max(smallestDirectionComponent, 1.0E-4f);
        float scale = extendedlightRadius / smallestDirectionComponent;
        direction = new Vector2(direction.x * scale, direction.y * scale);
        Vector2 intersection = new Vector2();
        if (Intersector.intersectLines(0.0f, 0.0f, direction.x, direction.y, edge.getPointA().x, edge.getPointA().y, edge.getPointB().x, edge.getPointB().y, intersection)) {
            return intersection;
        }
        return null;
    }

    private void addBoundingBoxEdges(PointLight light, TreeMap<Vector2, List<Edge>> sortedPointsToWallEdges, TiledMap worldMap, Set<Edge> allEdges) {
        Vector2 lightWorldPosition = light.getWorldPosition();
        float left = 0.0f - Math.min(PointLight.LIGHT_RADIUS, lightWorldPosition.x);
        float right = 0.0f + Math.min(PointLight.LIGHT_RADIUS, (float)worldMap.getWidth() - lightWorldPosition.x);
        float bottom = 0.0f - Math.min(PointLight.LIGHT_RADIUS, lightWorldPosition.y);
        float top = 0.0f + Math.min(PointLight.LIGHT_RADIUS, (float)worldMap.getHeight() - lightWorldPosition.y);
        Vector2 lowerLeft = new Vector2(left, bottom);
        Vector2 upperLeft = new Vector2(left, top);
        Vector2 upperRight = new Vector2(right, top);
        Vector2 lowerRight = new Vector2(right, bottom);
        this.addEdgeToMap(new Edge(lowerLeft, upperLeft), sortedPointsToWallEdges, allEdges);
        this.addEdgeToMap(new Edge(upperLeft, upperRight), sortedPointsToWallEdges, allEdges);
        this.addEdgeToMap(new Edge(upperRight, lowerRight), sortedPointsToWallEdges, allEdges);
        this.addEdgeToMap(new Edge(lowerRight, lowerLeft), sortedPointsToWallEdges, allEdges);
    }

    private void addEdgeToMap(Edge edge, TreeMap<Vector2, List<Edge>> sortedPointsToWallEdges, Set<Edge> allEdges) {
        edge = edge.reorderPointsClockwiseAroundOrigin();
        this.addPointToMap(edge.getPointA(), edge, sortedPointsToWallEdges);
        this.addPointToMap(edge.getPointB(), edge, sortedPointsToWallEdges);
        allEdges.add(edge);
    }

    private void addPointToMap(Vector2 point, Edge edge, TreeMap<Vector2, List<Edge>> sortedPointsToWallEdges) {
        if (!sortedPointsToWallEdges.containsKey(point)) {
            LinkedList<Edge> wallEdgeArray = new LinkedList<Edge>();
            wallEdgeArray.add(edge);
            sortedPointsToWallEdges.put(point, wallEdgeArray);
        } else {
            sortedPointsToWallEdges.get(point).add(edge);
        }
    }
}

